/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.ModelUnitDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.ModelUnitVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTComboBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.util.SCTSelection;
import com.quantumdata.sct.util.keygen.KeyGeneratorFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CreateNewUnit
extends JDialog
implements ActionListener {
    private SCTTextField modelnumberTextField;
    private SCTTextField portnumberTextField;
    private SCTButton saveButton;
    private SCTButton cancelButton;
    private SCTComboBox portTypeComboBox;
    private boolean isSaveButtonPressed;
    private UnitVO unitVO;

    public CreateNewUnit(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.init();
    }

    public CreateNewUnit(JFrame jFrame, UnitVO unitVO) {
        super((Frame)jFrame, true);
        this.unitVO = unitVO;
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        this.setTitle("Add New Unit:Device");
        container.add(this.newUnitPanel());
        this.pack();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CreateNewUnit.this.pack();
            }
        });
        SCTConstants.screenCenterPlacement(this);
    }

    private SCTPanel newUnitPanel() {
        SCTPanel sCTPanel = new SCTPanel();
        BoxLayout boxLayout = new BoxLayout(sCTPanel, 1);
        sCTPanel.setLayout(boxLayout);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        SCTLabel sCTLabel = new SCTLabel("Unit Serial Number");
        gridBagConstraints.gridwidth = -1;
        sCTPanel2.add((Component)sCTLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.modelnumberTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        sCTPanel2.add((Component)this.modelnumberTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        SCTLabel sCTLabel2 = new SCTLabel("Port Type");
        gridBagConstraints.gridwidth = -1;
        sCTPanel2.add((Component)sCTLabel2, gridBagConstraints);
        this.portTypeComboBox = new SCTComboBox();
        this.portTypeComboBox.addItem("Input");
        this.portTypeComboBox.addItem("Output");
        this.portTypeComboBox.addItem("N/A");
        this.portTypeComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        sCTPanel2.add((Component)this.portTypeComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        SCTLabel sCTLabel3 = new SCTLabel("Unit Port Number");
        gridBagConstraints.gridwidth = -1;
        sCTPanel2.add((Component)sCTLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.portnumberTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        sCTPanel2.add((Component)this.portnumberTextField, gridBagConstraints);
        SCTPanel sCTPanel3 = new SCTPanel(new FlowLayout(1, 20, 0));
        this.saveButton = new SCTButton("Add Unit");
        this.saveButton.addActionListener(this);
        sCTPanel3.add(this.saveButton);
        this.cancelButton = new SCTButton("Cancel");
        this.cancelButton.addActionListener(this);
        sCTPanel3.add(this.cancelButton);
        sCTPanel.add(sCTPanel2);
        sCTPanel.add(sCTPanel3);
        return sCTPanel;
    }

    public boolean isSaveButtonPressed() {
        return this.isSaveButtonPressed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            MessageOptionPane messageOptionPane = new MessageOptionPane();
            try {
                this.unitVO.setId(KeyGeneratorFactory.getUnitKG().generateUniqueKey());
                String string = this.modelnumberTextField.getText();
                String string2 = (String)this.portTypeComboBox.getSelectedItem();
                if (string2.equalsIgnoreCase("N/A")) {
                    string2 = "Port";
                }
                string = string + ":" + string2 + " " + this.portnumberTextField.getText();
                this.unitVO.setSerialNumber(string);
                String string3 = SCTSelection.instance().getModelID();
                ModelUnitDAO modelUnitDAO = (ModelUnitDAO)XMLDAOFactory.getModelUnitDAO();
                ModelUnitVO modelUnitVO = (ModelUnitVO)modelUnitDAO.read(string3);
                modelUnitVO.getUnits().add(this.unitVO);
                modelUnitVO.setDirty();
                modelUnitDAO.update(modelUnitVO);
                this.isSaveButtonPressed = true;
                MessageOptionPane.ShowMessage(this, "Successfully added new unit", "Add");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowMessage(this, "Error adding new unit", "Add");
            }
            this.dispose();
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

